
program load_pcx_image;

uses crt,dos,graph;

var
  x,y : integer;

procedure LOAD_PCX (filename: string);

const
   max_width    = 4000;
   compress_num = $C0;
   max_block    = 4096;
   red          = 0;
   green        = 1;
   blue         = 2;

type
   file_buffer = array [0..127] of byte;
   block_array = array [0..MAX_BLOCK] of byte;
   pal_array   = array [0..255, RED..BLUE] of byte;
   ega_array   = array [0..16] of byte;
   line_array  = array [0..MAX_WIDTH] of byte;

   pcx_header = record

      Manufacturer   : byte;
      Version        : byte;
      Encoding       : byte;
      Bits_per_pixel : byte;
      Xmin           : integer;
      Ymin           : integer;
      Xmax           : integer;
      Ymax           : integer;
      Hdpi           : integer;
      Vdpi           : integer;
      ColorMap       : array [0..15, RED..BLUE] of byte;
      Reserved       : byte;
      Nplanes        : byte;
      Bytes_per_line : integer;
      PaletteInfo    : integer;
      HscreenSize    : integer;
      VscreenSize    : integer;
      Filler         : array [74..127] of byte;
  end;

var
  f            :file;              { file for reading block data }
  BlockData    :block_array;       { 4k data buffer }
  Header       :pcx_header;        { PCX file header }
  Palette256   :pal_array;         { place to put 256 color palette }
  PaletteEGA   :ega_array;         { place to put 17 EGA palette values }
  PCXline      :line_array;        { place to put uncompressed data }
  Ymax         :integer;           { maximum Y value on screen }
  NextByte     :integer;           { index into file buffer in ReadByte }
  Index        :integer;           { PCXline index - where to put Data }
  Data         :byte;              { PCX compressed data byte }
  PictureMode  :integer;           { Graphics mode number }
  Reg          :Registers;         { Register set - used for int 10 calls }
  k,kmax       :integer;

procedure ShowEGA (Y: integer);

var
  i,j,l,m,t :integer;
  EGAplane  :integer;
  EGAscreen :array [0..32000] of byte absolute $A000:$0000;

begin
  EGAplane := $0100;
  PortW [$3CE] := $0005;
  t := (Header.Xmax - Header.Xmin + 1);
  m := t and 7;
  l := (t + 7) shr 3;
  if (l >= 80) then begin
    l := 80;
    m := 0;
  end;
  if (m <> 0) then m := $FF shl (8 - m)
    else m := $FF;
  for i := 0 to Header.Nplanes-1 do
  begin
    j := i * Header.Bytes_per_line;
    t := j + l - 1;
    PCXline [t] := PCXline [t] and m;
    PortW [$3C4] := EGAplane + 2;
    Move (PCXline [j], EGAscreen [Y * 80], l);
    EGAplane := EGAplane shl 1;
  end;
  PortW [$3C4] := $0F02;
end;

procedure VGA16palette;

var
  i :integer;

begin
  for i := 0 to 15 do PaletteEGA [i] := i;
  PaletteEGA [16] := 0;                { border color }
  Reg.ah := $10;                       { Set Palette Call }
  Reg.al := $02;                       { set a block of palette registers }
  Reg.dx := ofs (PaletteEGA);          { offset of block }
  Reg.es := seg (PaletteEGA);          { segment of block }
  intr ($10, Reg);                     { call interrupt }
  for i := 0 to 15 do begin                                          { R, G, and B must be 0..63 }
    Palette256 [i, RED]   := Header.ColorMap [i, RED]   shr 2;
    Palette256 [i, GREEN] := Header.ColorMap [i, GREEN] shr 2;
    Palette256 [i, BLUE]  := Header.ColorMap [i, BLUE]  shr 2;
  end;
  Reg.ah := $10;                       { Set DAC Call }
  Reg.al := $12;                       { set a block of DAC registers }
  Reg.bx := 0;                         { first DAC register number }
  Reg.cx := 255;                       { number of registers to update }
  Reg.dx := ofs (Palette256);          { offset of block }
  Reg.es := seg (Palette256);          { segment of block }
  intr ($10, Reg);                     { call interrupt }
end;

procedure ReadHeader;

begin
  BlockRead (f, Header, 128);
  if (Header.Manufacturer <> 10) or (Header.Encoding <> 1) then close(f);
  if (Header.Nplanes = 4) and (Header.Bits_per_pixel = 1) then begin
    PictureMode := VGA;
    Ymax := 479;
  end;
  Index    := 0;
  NextByte := MAX_BLOCK;
end;

procedure ReadByte;

var
   NumBlocksRead: integer;

begin
  if NextByte = MAX_BLOCK then begin
    BlockRead (f, BlockData, MAX_BLOCK, NumBlocksRead);
    NextByte := 0;
  end;
  data := BlockData [NextByte];
  inc (NextByte);
end;

procedure Read_PCX_Line;

var
  count: integer;
  bytes_per_line: integer;

begin
  bytes_per_line := Header.Bytes_per_line * Header.Nplanes;
  if Index <> 0 then FillChar (PCXline [0], Index, data);
  while (Index < bytes_per_line) do begin
    ReadByte;
    if (data and $C0) = compress_num then begin
      count := data and $3F;
      ReadByte;
      FillChar (PCXline [Index], count, data);
      inc (Index, count);
    end
    else begin
      PCXline [Index] := data;
      inc (Index);
    end;
  end;
  Index := Index - bytes_per_line;
end;

label naar_einde;

begin
  assign (f, filename);
  {$I-} reset(f,1); {$I+}
  if ioresult =0 then begin
    ReadHeader;
    if Header.Bits_per_pixel <> 1 then goto naar_einde; { ALS HET EEN 256 }
    if Header.Version = 5 then vga16Palette;         { KLEUREN PLAATJE IS }
    kmax := Header.Ymin + Ymax;
    if Header.Ymax < kmax then kmax :=Header.ymax;
    if PictureMode =VGA then for k :=Header.Ymin to kmax do begin
      Read_PCX_Line;
      ShowEGA (k);
    end;
    close (f);
  end
  else begin
    naar_einde:
    sound(500);delay(50);sound(700);delay(50);nosound;
  end;
end;

begin
  x :=vga;
  y :=vgahi;
  initgraph(x,y,'');
  load_pcx('diana.pcx');
  readln;
end.