program electr_organ;

{ Graphics made by Jos Dickmann (c) 1998 }
{ E-mail : j.w.j.dickmann@universal.nl }

uses crt,dos,graph;

type
  CardType = (SB_1, SB_2, SBPro, SB_16, SBAWE32);
  Str4     = string[4];
  TSBdata  = record
               Portno : word;
               ctype  : CardType;
               irq    : byte;
               dma    : byte;
             end;
  TFMInst  = record
               modchr, carchr, modlev, carlev,
               modatk, caratk, modsus, carsus,
               modwav, carwav, feedback : byte;
               reserved : array[1..5] of byte;
             end;
const
  CardName : array [1..5] of string[8] = (
             'SB v1.0', 'SB v2.0', 'SB Pro', 'SB 16', 'SB AWE32');
  Notefreq : array[1..12] of word = ($16B,$181,$198,$1B0,$1CA,$1E5,
                                     $202,$220,$241,$263,$287,$2AE);
const
  waitctr   = $400;
  FMaddr    = $388;
  EOI       = $20;
  PIC       = $20;
  PICStatus = $21;
  Modofs    : array[1..9] of byte = (0,1,2,8,9,10,16,17,18);
  Carofs    : array[1..9] of byte = (3,4,5,11,12,13,19,20,21);

var
  p,pp,x,y,xx          : integer;
  x1,y1,teller         : integer;
  ch                   : char;
  SBdata               : TSBdata;
  c                    : TSBData;
  v                    : word;
  f                    : tfminst;
  s,ss                 : string;
  t                    : string[3];
  n,o,pal              : byte;


Procedure WAIT(ms : Word); Assembler;
Asm
  mov ax, 1000;
  mul ms;
  mov cx, dx;
  mov dx, ax;
  mov ah, $86;
  int $15;
end;

procedure CLICK(freq,delay :integer);

begin
  sound(freq);wait(delay);nosound;
end;

procedure CLEAR_BUFFER;

begin
  memw[$0000:$041C] :=memw[$0000:$041A];
end;

procedure WRITE_TEXT(x,y :integer;text :string;bg,vg,soort,size :byte);

begin
  settextstyle(soort,0,size);
  setcolor(bg);outtextxy(x,y,text);
  setcolor(vg);outtextxy(x+1,y+1,text);
  settextstyle(0,0,0);
end;

procedure FILL_BAR(x,y,xx,yy :integer;color,raster :byte);

const
  soort :array[0..27] of fillpatterntype =
                   (($ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff),
                    (0,$fb,$fb,$fb,0,$df,$df,$df),
                    (0,$10,$28,$44,$28,$10,0,0),
                    ($22,0,$88,0,$22,0,$88,0),
                    ($cc,$33,$cc,$33,$cc,$33,$cc,$33),
                    ($aa,$55,$aa,$55,$aa,$55,$aa,$55),
                    ($94,$84,$48,$30,0,$c1,$22,$14),
                    ($aa,$aa,$aa,$aa,$aa,$aa,$aa,$aa),
                    ($ff,0,$ff,0,$ff,0,$ff,0),
                    ($ff,$1,$7d,$45,$5d,$41,$7f,0),
                    ($01,$82,$44,$28,$10,$20,$40,$80),
                    (0,$3c,$42,$42,$42,$42,$3c,0),
                    (0,$7e,$7e,$7e,$7e,$7e,$7e,0),
                    ($81,$42,$24,$18,$18,$24,$42,$81),
                    (0,$ec,$2a,$2a,$2a,$aa,$ec,0),
                    (0,$08,$18,$3f,$3f,$18,$08,0),
                    (0,0,$7e,$42,$7e,$42,$7e,$42),
                    ($80,$7f,$41,$41,$41,$41,$41,$7f),
                    (0,$5d,$3e,$6b,$7f,$63,$36,$5d),
                    (0,0,$04,$08,$90,$a0,$c0,$f0),
                    ($92,$24,$49,$92,$24,$49,$92,$24),
                    ($b1,$22,$14,$14,$22,$91,$48,$24),
                    ($18,$3c,$3c,$7e,$7e,$3c,$3c,$18),
                    ($e7,$c3,$81,$18,$18,$81,$c3,$e7),
                    ($2,$91,$68,$8,$10,$16,$89,$40),
                    ($ff,$81,$81,$81,$81,$81,$81,$ff),
                    (0,0,$81,$81,$42,$24,$18,$18),
                    ($c3,$42,$5a,$7e,$7e,$5a,$42,$c3));
begin
  if raster < 28 then begin
    setfillpattern(soort[raster],color);
    setfillstyle(12,color);
    bar(x,y,xx,yy);
  end;
end;


procedure BUTTONOFF(x,y,xx,yy :integer;text :string;kleur :byte;r :boolean);

var
  hor,ver :real;

begin
  setcolor(0);if r =true then rectangle(x,y,xx,yy);
  setfillstyle(1,7);bar(x+1,y+1,xx-1,yy-1);
  setcolor(15);
  line(x+1,y+1,xx-1,y+1);line(xx-1,y+1,xx-1,yy-1);
  setcolor(8);
  line(x+1,yy-1,xx-1,yy-1);line(x+1,y+1,x+1,yy-1);
  hor :=((xx-x)/2)+x-(length(text)*7)/2;ver :=((yy-y)/2)+y+2;
  setcolor(kleur);outtextxy(round(hor),round(ver)-6,text);
end;


procedure win_screen(x,y,xx,yy :integer;text :string;lijn :boolean;knoppen :byte);

begin
  buttonOff(x,y,xx,yy,'',1,true);
  fill_bar(x+3,y+3,xx-3,y+20,1,0);              { blauwe band }
  write_text(x+8,y+6,text,1,15,0,0);

  buttonOff(xx-59,y+4,xx-42,y+19,'',0,false);   { links }
  setcolor(0);line(xx-54,y+15,xx-47,y+15);
  buttonOff(xx-40,y+4,xx-23,y+19,'',0,false);   { midden }
  setcolor(0);rectangle(xx-36,y+8,xx-27,y+15);
  buttonOff(xx-21,y+4,xx-5,y+19,'X',0,false);   { rechts }

  if lijn =true then begin
    setcolor(8);line(x+4,y+38,xx-3,y+38);       { horizontale streep }
    setcolor(15);line(x+4,y+39,xx-3,y+39);
  end;

  { SCHUINE LIJNEN }
  for p :=0 to 6 do begin
    setcolor(0);
    line(xx-3,yy-22+(p*3),xx-22+(p*3),yy-3);
    setcolor(15);
    line(xx-3,yy-21+(p*3),xx-21+(p*3),yy-3);
  end;
end;


Function  WordToHex(no : word): Str4;

const
  h : array [0..15] of char = '0123456789ABCDEF';

begin
  WordToHex:=h[hi(no) shr 4]+h[hi(no) and 15]+h[lo(no) shr 4]+
             h[lo(no) and 15];
end;

Function ResetChip(Portno : Word) : Boolean; Assembler;
asm
  mov    bx,-1
  mov    dx,[Portno]
  add    dl,6
  mov    al,1
  out    dx,al
  mov    cx,waitctr

@@1:
  loop   @@1
  dec    al
  out    dx,al
  mov    cx,waitctr

@@2:
  loop   @@2
  add    dl,8
  mov    cx,waitctr

@@testreadybit:
  in     al,dx
  test   al,80h
  loopz  @@testreadybit
  jz     @@SBnotpresent
  sub    dl,4
  mov    cx,waitctr

@@pollfor0AAh:
  in     al,dx
  cmp    al,0AAh
  je     @@done
  loop   @@pollfor0AAh

@@SBnotpresent:
  xor    bx,bx

@@done:
  mov    ax,bx
end;

Function  SBRead: byte; assembler;
asm
  mov     dx,[SBData.Portno]
  add     dl,0eH
  mov     cx,waitctr
@@loopit:
  in      al,dx
  test    al,80H
  loopz   @@loopit
  sub     dx,4
  in      al,dx
end;

Procedure SBWrite(Data : byte); assembler;
asm
  mov    dx,[SBData.Portno]
  add    dl,0cH
  mov    cx,waitctr
@@loopit:
  in     al,dx
  test   al,80H
  loopnz @@loopit
  mov    al,[Data]
  out    dx,al
end;

Function  GetDSPVersion : Word; assembler;
asm
  push   00e1H
  call   SBwrite
  call   SBread
  mov    ah,al
  call   SBread
end;

Procedure FMwrite(reg, data : byte); assembler;
asm
  mov    dx,FMaddr
  mov    al,[reg]
  out    dx,al
  mov    cx,6
@@1:
  in     al,dx
  loop   @@1
  inc    dl
  mov    al,[data]
  out    dx,al
  dec    dl
  mov    cx,35
@@2:
  in     al,dx
  loop   @@2
end;

Procedure FMreset;
begin
  FMwrite(1,0);
end;

Procedure FMKeyon(channel: byte; freq: word; octave: byte);
begin
  FMWrite($A0+channel-1,freq and $FF);
  FMWrite($B0+channel-1,(freq shr 8) or (octave shl 2) or $20);
end;

Procedure FMKeyoff(channel: byte);
begin
  FMWrite($B0+channel-1,0);
end;
  {
Procedure FMSetVolume(channel, vol: byte);
begin
  FMWrite($40+Modofs[channel],vol and $3F);
  FMWrite($40+Carofs[channel],vol and $3F);
end;
 }
Procedure FMSetup(channel: byte; FMInst : TFMInst);
var
  i, j : byte;
begin
  i:=modofs[channel]; j:=carofs[channel];
  FMWrite($20+i,FMInst.modchr); FMWrite($20+j,FMInst.carchr);
  FMWrite($40+i,FMInst.modlev); FMWrite($40+j,FMInst.carlev);
  FMWrite($60+i,FMInst.modatk); FMWrite($60+j,FMInst.caratk);
  FMWrite($80+i,FMInst.modsus); FMWrite($80+j,FMInst.carsus);
  FMWrite($E0+i,FMInst.modwav); FMWrite($E0+j,FMInst.carwav);
  FMWrite($C0+channel-1,FMInst.feedback);
end;

Procedure SBSetcard(CardData : TSBdata);
begin
  with SBData do
  begin
    portno:=CardData.portno;
    ctype :=CardData.ctype;
    irq   :=CardData.irq;
    dma   :=CardData.dma;
  end;
end;

Function AutoDetectIRQ : Byte;

var
  i       : Integer;
  s       : string;
  j       : byte;

begin
  for I:=1 to EnvCount do
  begin
    s:=EnvStr(i);
    if copy(s,1,7)='BLASTER' then break;
  end;
  if copy(s,1,7)<>'BLASTER' then
  begin
    AutoDetectIRQ:=0;
    exit;
  end;
  j:=pos('I',s);
  if j=0 then
  begin
    j:=pos('i',s);
    if j=0 then
    begin
      AutoDetectIRQ:=0;
      exit;
    end;
  end;
  s:=copy(s,j+1,1);
  j:=ord(s[1])-48;
  AutoDetectIRQ:=j;
end;

Function AutoDetectDMA : Byte;
var
  i       : Integer;
  s       : string;
  j       : byte;
begin
  for I:=1 to EnvCount do
  begin
    s:=EnvStr(i);
    if copy(s,1,7)='BLASTER' then break;
  end;
  if copy(s,1,7)<>'BLASTER' then
  begin
    AutoDetectDMA:=0;
    exit;
  end;
  j:=pos('D',s);
  if j=0 then
  begin
    j:=pos('d',s);
    if j=0 then
    begin
      AutoDetectDMA:=0;
      exit;
    end;
  end;
  s:=copy(s,j+1,1);
  j:=ord(s[1])-48;
  AutoDetectDMA:=j;
end;

Procedure DetectSB (var CardData : TSBdata); assembler;
asm
  { Port AutoDetect }
  mov    ax,ds
  mov    es,ax
  mov    di,[offset SBData]
  mov    si,di
  mov    ax,220h
@@detectionloop:
  mov    bx,ax
  push   bx
  push   ax
  call   ResetChip
  pop    bx
  cmp    ax,-1
  je     @@success
  mov    ax,bx
  add    ax,20h
  cmp    ax,300h
  jb     @@detectionloop
  xor    bx,bx
@@success:
  mov    ax,bx
  cld
  stosw

  { Card Type AutoDetect }
  call   GetDSPVersion
  cmp    ah,4
  jne    @@nexts
  cmp    al,10
  jl     @@nexts
  inc    ah
@@nexts:
  mov    al,ah
  cld
  stosb

  { IRQ autodetect }
  push   es
  push   di
  push   si
  call   AutoDetectIRQ
  pop    si
  pop    di
  pop    es
  cld
  stosb

  { DMA autodetect }
  push   es
  push   di
  push   si
  call   AutoDetectDMA
  pop    si
  pop    di
  pop    es
  cld
  stosb
  les    di,[CardData]
  mov    cx,5
  cld
  rep    movsb
end;

procedure organ_toets(nummer :byte);

begin
  n :=0;
  FMKeyoff(2);
    case nummer of

   { 1e OCTAAF }
   90: begin n:=1; o:=2; x1 :=155;y1 :=240;end;  { Z }
   83: begin n:=2; o:=2; x1 :=165;y1 :=180;end;  { S }
   88: begin n:=3; o:=2; x1 :=173;y1 :=240;end;  { X }
   68: begin n:=4; o:=2; x1 :=188;y1 :=180;end;  { D }
   67: begin n:=5; o:=2; x1 :=191;y1 :=240;end;  { C }
   86: begin n:=6; o:=2; x1 :=209;y1 :=240;end;  { V }
   71: begin n:=7; o:=2; x1 :=219;y1 :=180;end;  { G }
   66: begin n:=8; o:=2; x1 :=227;y1 :=240;end;  { B }
   72: begin n:=9; o:=2; x1 :=240;y1 :=180;end;  { H }
   78: begin n:=10;o:=2; x1 :=245;y1 :=240;end;  { N }
   74: begin n:=11;o:=2; x1 :=261;y1 :=180;end;  { J }
   77: begin n:=12;o:=2; x1 :=263;y1 :=240;end;  { M }

   { 2e OCTAAF }
   44: begin n:=1; o:=3; x1 :=281;y1 :=240;end;  { , }
   76: begin n:=2; o:=3; x1 :=291;y1 :=180;end;  { L }
   46: begin n:=3; o:=3; x1 :=299;y1 :=240;end;  { . }
   59: begin n:=4; o:=3; x1 :=314;y1 :=180;end;  { ; }
   47: begin n:=5; o:=3; x1 :=317;y1 :=240;end;  { / }
   81: begin n:=6; o:=3; x1 :=335;y1 :=240;end;  { Q }
   50: begin n:=7; o:=3; x1 :=345;y1 :=180;end;  { 2 }
   87: begin n:=8; o:=3; x1 :=353;y1 :=240;end;  { W }
   51: begin n:=9; o:=3; x1 :=366;y1 :=180;end;  { 3 }
   69: begin n:=10;o:=3; x1 :=371;y1 :=240;end;  { E }
   52: begin n:=11;o:=3; x1 :=387;y1 :=180;end;  { 4 }
   82: begin n:=12;o:=3; x1 :=389;y1 :=240;end;  { R }

   { 3e OCTAAF }
   84: begin n:=1; o:=4; x1 :=407;y1 :=240;end;  { T }
   54: begin n:=2; o:=4; x1 :=417;y1 :=180;end;  { 6 }
   89: begin n:=3; o:=4; x1 :=425;y1 :=240;end;  { Y }
   55: begin n:=4; o:=4; x1 :=440;y1 :=180;end;  { 7 }
   85: begin n:=5; o:=4; x1 :=443;y1 :=240;end;  { U }
   73: begin n:=6; o:=4; x1 :=461;y1 :=240;end;  { I }
   57: begin n:=7; o:=4; x1 :=471;y1 :=180;end;  { 9 }
   79: begin n:=8; o:=4; x1 :=489;y1 :=240;end;  { O }
   48: begin n:=9; o:=4; x1 :=492;y1 :=180;end;  { 0 }
   80: begin n:=10;o:=4; x1 :=497;y1 :=240;end;  { P }
   45: begin n:=11;o:=4; x1 :=513;y1 :=180;end;  { - }
   91: begin n:=12;o:=4; x1 :=515;y1 :=240;end;  { [ }
  end;
  if n>0 then FMKeyon(2,NoteFreq[n],o);
end;

procedure organ;

const
  coor : array[1..5] of integer =(159,182,213,234,255); { black keys }

  lett : array[1..36] of string[1] =
  ('Z','X','C','V','B','N','M',',','.','/','Q','W','E','R','T','Y','U',
   'I','O','P','[',
   'S','D','G','H','J','L',';','2','3','4','6','7','9','0','-');


begin
  fill_bar(0,0,639,479,8,20);
  win_screen(140,120,540,280,'Electronic Organ',true,3);

  write_text(100,340,'KEYS IS PLAY / ESCAPE IS STOP',11,3,0,2);
  write_text(90,370,'JOS DICKMANN SOFTWARE (c) 1998',14,6,0,2);

  { KLAVIER }
  x :=150;xx :=0;teller :=1;
  for pp :=1 to 3 do begin
    for p :=1 to 7 do begin                            { white keys }
      fill_bar(x,175,x+16,260,15,0);
      putpixel(x,260,7);putpixel(x+16,260,7);
      write_text(x+4,265,lett[teller],7,8,0,0);
      inc(x,18);inc(teller);
    end;
  end;
  xx :=0;
  for pp :=1 to 3 do begin
    for p :=1 to 5 do begin
      fill_bar(coor[p]+xx,175,coor[p]+10+xx,230,0,0);  { black keys }
      setcolor(7);
      rectangle(coor[p]-1+xx,174,coor[p]+11+xx,231);
      write_text(coor[p]+xx+1,163,lett[teller],7,8,0,0);
      inc(teller);
    end;
    inc(xx,126);
  end;

  DetectSB(c);
  If c.portno=0 then exit;

  str(c.irq,s);str(c.dma,ss);
  write_text(150,145,WordToHex(c.portno)+'h'+
  ' of type '+cardname[ord(c.ctype)]+' with IRQ '+s+' and DMA '+ss,7,0,0,0);

  with f do begin
    modchr:=$41; carchr:=$41; modlev:=$8a; carlev:=$40;
    modatk:=$F1; caratk:=$F1; modsus:=$31; carsus:=$33;
    modwav:=0;   carwav:=0;   feedback:=6;
  end;

  FMReset;FMSetup(2,f);
  x1 :=281;y1 :=240;
  repeat
    clear_buffer;
    repeat
      ch :=upcase(readkey);
    until ch in[#27,#44..#91];

    if ch in[#27] then begin
      FMKeyoff(2);
      FMReset;
      exit;
    end;

    organ_toets(ord(ch));
    pal :=getpixel(x1,y1);
    setfillstyle(1,13);floodfill(x1,y1,7);wait(10);
    setfillstyle(1,pal);floodfill(x1,y1,7);
  until ch =#27;
end;

BEGIN
  with SBdata do begin
    portno:=$220;
    ctype :=sb_16;
    irq   :=7;
    dma   :=1;
  end;
  x :=vga;
  y :=vgahi;
  initgraph(x,y,'');
  organ;
  closegraph;
  halt;
END.
